//  Listing 11.3. Przecienie operatora konkatenacji z obiektem - parametrem 
//  przekazywanym poprzez warto

#include <iostream>
using namespace std;

class String 			// dynamiczne zapamitywanie tablicy typu char
{
char *str; 
int len;
  public:
String (int length=0); 			// konstruktor konwertujcy / domylny
String(const char*); 			// konstruktor konwertujcy
~String (); 				// przydzia dynamicznej pamici
void operator += (const String); 	// konkatenacja innego obiektu String
void modify(const char*); 		// zmiana zawartoci tablicy znakowej
const char* show() const; 		// zwrot wskanika do macierzy
} ;

String::String(int length)
{ 
len = length;
str = new char[len+1];
if (str==NULL) exit(1);
str[0] = 0;  				// pusty acuch o dugoci zerowej - to jest OK
}

String::String(const char* s)
{ 
len = strlen(s); 			// pomiar dugoci tekstu wejciowego
str = new char[len+1]; 			// przydzia wystarczajcej iloci miejsca na stercie
if (str==NULL) exit(1); 		// sprawd, czy si powiodo
strcpy(str,s);  			// kopiuj wejciowy tekst na stert
}

String::~String()
{ 
delete str;  					// zwrot pamici na stercie (nie wskanika!)
}

void String::operator += (const String s) 	// przez warto
{ 
len = strlen(str) + strlen(s.str); 		// cakowita dugo
char *p = new char[len + 1]; 			// przydziel wystarczajc ilo miejsca
if (p==NULL) exit(1); 				// sprawd, czy si powiodo
strcpy(p,str); 					// kopiuj pierwsz cz wynikowego tekstu
strcat(p,s.str); 				// dodaj drug cz tekstu
delete str; 					// wana czynno
str = p;  					// dopiero teraz p moe znikn
}

const char* String::show() const 		// chro dane przed zmian
 { return str; }

void String::modify(const char a[]) 		// tu bez zarzdzania pamici
{ 
strncpy(str,a,len-1); 				// ochrona przed przepenieniem
str[len-1] = 0;  				// poprawne zakoczenie acucha znakw
}

int main()
{ 
String u("This is a test. ");
	// po spolszczeniu: String u("To jest tekst. ");
String v("Nothing can go wrong.");
	// po spolszczeniu: String v("Nic nie moe pj le");
cout << " u = " << u.show() << endl; 		// wynik jest OK
cout << " v = " << v.show() << endl; 		// wynik jest OK
u += v; 					// oznacza:  u.operator+=(v);
cout << " u = " << u.show() << endl; 		// wynik jest OK
cout << " v = " << v.show() << endl; 		// tu wynik nie bdzie OK
v.modify("Let us hope for the best."); 		// uszkodzenie pamici
	// po spolszczeniu: String v("Nasza nadzieja w 'b'"); <- uszkodzenie
cout << " v = " << v.show() << endl; 		// ????
return 0;
}
